// LDIST3.C - Test program for LDIST.C module
//
// Tests the l_dist_list() function by compairing each name in a list with
// the list itself.
//
// Written initailly by R. Bruce Roberts, MCI Systems Engineering, 1/7/93
// Compiled with Borland C++, V3.1
//
//---------------------------------------------------------------------------
// Revision History:
//
// Date     Ini   Comments
// -------- ---   ---------------
// 01/08/93 RBR   Test program initially created and tested.
// 08/30/94 RBR   Header modified for forwarding to CUJ
//
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ldist.h"


char *names[] =
{
   "ADRAGNA",
   "ANDERSON",
   "BASCHAL",
   "BAUERS",
   "BECHT",
   "BISHOP",
   "BOOKER",
   "BORNER",
   "BROOKS",
   "BULLINGTON",
   "BUSH",
   "CAPERS",
   "CARVER",
   "CASCIO",
   "CLAUS",
   "COMBS",
   "CONLEY",
   "COOPER",
   "COURTER",
   "DEAVENPORT",
   "EMMART",
   "FARMER",
   "FRY",
   "GAVAN",
   "GEYER",
   "GIBLETTE",
   "GLEASON",
   "GOSS",
   "GRABOWSKI",
   "GRAHAM",
   "GRAVES",
   "GRIMM",
   "GUNDRUM",
   "HAASE",
   "HAMMOND",
   "HEITHOLD",
   "HENSS",
   "HERBERT",
   "HOFF",
   "HUSA",
   "JENKINS",
   "KEANE",
   "KIDDER",
   "KLEINHEINZ",
   "KUTCH",
   "LAMBE",
   "LYNCH",
   "MARTIN",
   "MARTIN",
   "MARTINEZ",
   "McBROOM",
   "McELHOES",
   "McFARLAND",
   "McNERNEY",
   "McWILLIAMS",
   "MINZER",
   "MOORE",
   "MORITZ",
   "NIEMCZYK",
   "O'REILLY",
   "PATEL",
   "PFISTER",
   "PUMFREY",
   "RABIN",
   "REED",
   "RENKIEWICZ",
   "RIDER",
   "ROBERTS",
   "ROESLE",
   "ROUNDY",
   "RUNDELL",
   "RYDER",
   "SCHROEDER",
   "SCHWARTZ",
   "SOOY",
   "STEPHENS",
   "STURM",
   "TANNER",
   "TOMLIN",
   "UNDERWOOD",
   "VETTER",
   "WEAVER",
   "WILLIAMS",
   "WILSON",
   "YOUNG",
   ""
};


//---------------------------------------------------------------------------
#define NUM_MATCHES     4
void main()
{
   int num, i, j, threshold;
   int dist[NUM_MATCHES];
   char *match[NUM_MATCHES];

   printf("Returns 'Levenstein Distance' of a list of names.\n");
   printf("Format is INDEX, Name compared, Threshold returned, and a list of\n");
   printf("up to %d matched names and L Distances.\n", NUM_MATCHES);

   for (i=0; names[i][0]; i++)
   {
      num = l_dist_list(names[i], names, match, dist,
                        NUM_MATCHES, &threshold);

      printf("#%03d %10.10s(%02d) - ", i, names[i], threshold);
      for (j=1; j<num; j++)
      {
         if (j>1) putchar(',');
         printf(" %10.10s(%02d)", match[j], dist[j]);
      }
      printf("\n");
   }

   exit(0);
}